import express from "express";
import expressLayouts from "express-ejs-layouts";
import session from "express-session";
import { db, testConnectionDb } from "./config/database.js";
import router from "./routes/router.js";
import User from "./models/User.js";
import Content from "./models/Content.js";
import Transaction from "./models/Transaction.js";
const app = express();

// Middleware parsing body
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Konfigurasi EJS & Layout
app.set("view engine", "ejs");
app.set("views", "./views");
app.use(expressLayouts);
app.set("layout", "./layout");

app.use(session({
  secret: "xyzjdjwuhsjdisiw7272874bj",
  resave: false,
  saveUninitialized: true,
  cookie: { maxAge: 1000 * 60 * 60 } // 1 jam
}));

// Set title default untuk semua halaman
app.use((req, res, next) => {
  res.locals.title = "Gilang";
  next();
});

/* Tes koneksi database
try {
  await testConnectionDb();
  await db.sync({alter:true});
} catch (error) {
  console.error("❌ Database error:", error);
}
*/

// ROUTES
app.use(router);
app.use((req,res)=>{res.status(404).json({msg:"ahalaman tidak di temukan"})})

// Jalankan server
app.listen(3000, () => {
  console.log("🚀 Server up and running at http://localhost:3000");
});