import { DataTypes } from "sequelize";
import { db } from "../config/database.js";

const Transaction = db.define("Transaction", {
  order_id: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
  },
  slug: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  amount: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  status: {
    type: DataTypes.STRING,
    allowNull: false,
    defaultValue: "pending"
  },
}, {
  tableName: "transactions",
  timestamps: true,
});

export default Transaction;